//
//  Presenting_Master_Detail_Views_with_UISplitViewControllerAppDelegate.m
//  Presenting Master-Detail Views with UISplitViewController
//
//  Created by Vandad Nahavandipoor on 10/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Presenting_Master_Detail_Views_with_UISplitViewControllerAppDelegate.h"
#import "RootViewController.h"
#import "DetailViewController.h"

@implementation 
  Presenting_Master_Detail_Views_with_UISplitViewControllerAppDelegate

@synthesize window = _window;
@synthesize navigationController = _navigationController;
@synthesize splitViewController = _splitViewController;
@synthesize detailViewController;

- (BOOL)            application:(UIApplication *)application 
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{

  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  if ([[UIDevice currentDevice] userInterfaceIdiom] 
      == UIUserInterfaceIdiomPhone) {
    
    RootViewController *controller = 
      [[RootViewController alloc]
       initWithNibName:@"RootViewController_iPhone"
                bundle:nil];
    
    self.navigationController = 
    [[UINavigationController alloc] 
     initWithRootViewController:controller];
    
    self.window.rootViewController = self.navigationController;
    
  } else {
    
    RootViewController *controller = 
      [[RootViewController alloc] 
       initWithNibName:@"RootViewController_iPad"
                bundle:nil];
    
    UINavigationController *navigationController = 
      [[UINavigationController alloc] 
       initWithRootViewController:controller];
    
    detailViewController = 
    [[DetailViewController alloc] 
     initWithNibName:@"DetailViewController_iPad"
              bundle:nil];
    
    self.splitViewController = [[UISplitViewController alloc] init];
    self.splitViewController.delegate = detailViewController;
    
    self.splitViewController.viewControllers = 
      [NSArray arrayWithObjects:
       navigationController,
       detailViewController, nil];
    
    self.window.rootViewController = self.splitViewController;
  }
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
